﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class PositionCamera : MonoBehaviour
{


    public GameObject gazeCursor;
    Vector3 pt1;
    Vector3 pt2;
    Vector3 pt3;
    int counter = 0;

    // Called by GazeGestureManager when the user performs a Select gesture
    void OnSelect()
    {
        counter++;

        // Do a raycast into the world that will only hit the Spatial Mapping mesh.
        var headPosition = Camera.main.transform.position;
        var gazeDirection = Camera.main.transform.forward;

        RaycastHit hitInfo;
        if (Physics.Raycast(headPosition, gazeDirection, out hitInfo,
            30.0f, SpatialMapping.PhysicsRaycastMask))
        {
            // Move this object's parent object to
            // where the raycast hit the Spatial Mapping mesh.

            if (counter == 1)
            {
                pt1.Set(gazeCursor.transform.position[0], gazeCursor.transform.position[1], gazeCursor.transform.position[2]);
                print("gazing at: " + gazeCursor.transform.position[0] + ", " + gazeCursor.transform.position[1] + ", " + gazeCursor.transform.position[2]);
                GameObject point1 = GameObject.CreatePrimitive(PrimitiveType.Sphere);
                point1.transform.position = new Vector3(pt1[0], pt1[1], pt1[2]);
                point1.transform.localScale = new Vector3(.02f, .02f, .02f);
                point1.GetComponent<Renderer>().material.color = Color.green;

            }
            else if (counter == 2)
            {
                pt2.Set(gazeCursor.transform.position[0], gazeCursor.transform.position[1], gazeCursor.transform.position[2]);
                print("gazing at: " + gazeCursor.transform.position[0] + ", " + gazeCursor.transform.position[1] + ", " + gazeCursor.transform.position[2]);
                GameObject point2 = GameObject.CreatePrimitive(PrimitiveType.Sphere);
                point2.transform.position = new Vector3(pt2[0], pt2[1], pt2[2]);
                point2.transform.localScale = new Vector3(.02f, .02f, .02f);
                point2.GetComponent<Renderer>().material.color = Color.green;
            }
            else if (counter == 3)
            {
                pt3.Set(gazeCursor.transform.position[0], gazeCursor.transform.position[1], gazeCursor.transform.position[2]);
                print("gazing at: " + gazeCursor.transform.position[0] + ", " + gazeCursor.transform.position[1] + ", " + gazeCursor.transform.position[2]);
                GameObject point3 = GameObject.CreatePrimitive(PrimitiveType.Sphere);
                point3.transform.position = new Vector3(pt3[0], pt3[1], pt3[2]);
                point3.transform.localScale = new Vector3(.02f, .02f, .02f);
                point3.GetComponent<Renderer>().material.color = Color.green;
            }
        }
    }

    GameObject workPlane;
    Plane thisPlane;
    // Update is called once per frame
    void Update()
    {
        if (Input.GetKeyDown(KeyCode.Space))
        {

            thisPlane = new Plane(pt1, pt2, pt3);

            print("distance: " + thisPlane.distance);
            print("normal: " + thisPlane.normal);
            //workPlaneA.transform.position = thisPlane.normal;
            workPlane = GameObject.CreatePrimitive(PrimitiveType.Plane);
            //workPlane.transform.up = thisPlane.normal;
            workPlane.transform.position = -thisPlane.normal * thisPlane.distance;
            workPlane.transform.position = new Vector3((pt1[0] + pt2[0] + pt3[0])/3, (pt1[1] + pt2[1] + pt3[1])/3, (pt1[2] + pt2[2] + pt3[2])/3);
            workPlane.transform.localScale *= 0.05f;
        }
        if (Input.GetKeyDown(KeyCode.N))
        {
            GameObject dot = GameObject.CreatePrimitive(PrimitiveType.Sphere);
            dot.transform.position = thisPlane.normal;
            dot.transform.localScale = new Vector3(.02f, .02f, .02f);
            dot.GetComponent<Renderer>().material.color = Color.red;
        }
            if (Input.GetKeyDown(KeyCode.B))
        {

        }
    }
}
